local assets =
{
	Asset("ANIM", "anim/magicpower.zip"),
    Asset("ATLAS", "images/inventoryimages/magicpower.xml"),
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("magicpower")
    inst.AnimState:SetBuild("magicpower")
    inst.AnimState:PlayAnimation("idle",true)

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:AddComponent("stackable")
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
    inst.components.inventoryitem.imagename = "magicpower"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/magicpower.xml"
    inst:AddComponent("selfstacker")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
	inst.Transform:SetScale(.5, .5, .5)
    MakeHauntableLaunchAndSmash(inst)

    return inst
end

return Prefab("magicpower", fn, assets)